'use strict';

System.register(['lodash', './api_service', './time_service', './templating_service', './cache'], function (_export, _context) {
    "use strict";

    var _, ApiService, TimeService, TemplatingService, Cache, _createClass, MetricsService, MetricsCache, metricsCaches;

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function getMetricsCache(backend) {
        if (metricsCaches === undefined) {
            metricsCaches = {};
        }

        if (metricsCaches[backend.url] === undefined) {
            metricsCaches[backend.url] = {
                values: new MetricsCache(),
                labels: new MetricsCache()
            };
        }

        return metricsCaches[backend.url];
    }

    function resetMetricsCache() {
        metricsCaches = undefined;
    }
    return {
        setters: [function (_lodash) {
            _ = _lodash.default;
        }, function (_api_service) {
            ApiService = _api_service.default;
        }, function (_time_service) {
            TimeService = _time_service.default;
        }, function (_templating_service) {
            TemplatingService = _templating_service.default;
        }, function (_cache) {
            Cache = _cache.default;
        }],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            MetricsService = function () {
                function MetricsService() {
                    _classCallCheck(this, MetricsService);
                }

                _createClass(MetricsService, null, [{
                    key: 'findMetrics',
                    value: async function findMetrics(backend, options) {
                        var normOptions = Object.assign({
                            areLabelsIncluded: false,
                            match: null,
                            plottableMetricTypes: ['%', 'byte', 'int', 'double', 'number', 'relativeTime']
                        }, options);

                        if (normOptions.match && normOptions.match.trim() === '') {
                            normOptions.match = null;
                        }

                        return getMetricsCache(backend).values.get(normOptions, async function () {
                            var response = await ApiService.fetchMetricsDescriptors(backend, normOptions);

                            return response.map(function (metric) {
                                return _.assign(metric, {
                                    isNumeric: normOptions.plottableMetricTypes.indexOf(metric.type) >= 0
                                });
                            }).sort(function (a, b) {
                                return a.id.localeCompare(b.id);
                            });
                        });
                    }
                }, {
                    key: 'findSegmentations',
                    value: async function findSegmentations(backend, options) {
                        var normOptions = Object.assign({ metric: false, match: null }, options);

                        if (normOptions.match && normOptions.match.trim() === '') {
                            normOptions.match = null;
                        }

                        return getMetricsCache(backend).labels.get(normOptions, async function () {
                            var result = await ApiService.fetchLabelDescriptors(backend, normOptions);

                            return result.sort(function (a, b) {
                                return a.id.localeCompare(b.id);
                            });
                        });
                    }
                }, {
                    key: 'findSegmentValues',
                    value: async function findSegmentValues(backend, filter, queryOptions, userTime) {
                        var evaluateUserTime = void 0;
                        if (userTime === null) {
                            var _ref = await TimeService.queryTimelines(backend),
                                timelines = _ref.timelines;

                            if (timelines.agents.filter(function (t) {
                                return t.from !== null && t.to !== null;
                            }).length > 0) {
                                evaluateUserTime = {
                                    from: (timelines.agents[0].to - timelines.agents[0].sampling) / 1000000,
                                    to: timelines.agents[0].to / 1000000,
                                    sampling: timelines.agents[0].sampling / 1000000
                                };
                            } else {
                                throw 'Unable to query metrics (data not available)';
                            }
                        } else {
                            evaluateUserTime = userTime;
                        }

                        return TimeService.validateTimeWindow(backend, evaluateUserTime).then(function (requestTime) {
                            return ApiService.send(backend, {
                                method: 'POST',
                                url: 'api/data/entity/metadata',
                                data: {
                                    time: {
                                        from: requestTime.from * 1000000,
                                        to: requestTime.to * 1000000
                                    },
                                    metrics: [queryOptions.labelName],
                                    filter: filter,
                                    paging: { from: queryOptions.from, to: queryOptions.to }
                                }
                            });
                        });
                    }
                }, {
                    key: 'queryMetrics',
                    value: async function queryMetrics(backend, templateSrv, query, options) {
                        var queryOptions = void 0;
                        if ((queryOptions = TemplatingService.validateLabelValuesQuery(query)) !== null) {
                            //
                            // return list of label values
                            //
                            return this.findSegmentValues(backend, TemplatingService.resolveQueryVariables(queryOptions.filter, templateSrv), queryOptions, options.userTime).then(function (result) {
                                return result.data.data.map(function (d) {
                                    return d[queryOptions.labelName];
                                });
                            });
                        } else if ((queryOptions = TemplatingService.validateLabelNamesQuery(query)) !== null) {
                            //
                            // return list of label names
                            //
                            return this.findSegmentations(backend, { match: queryOptions.pattern }).then(function (result) {
                                return result.map(function (metric) {
                                    return metric.id;
                                });
                            });
                        } else if ((queryOptions = TemplatingService.validateMetricsQuery(query)) !== null) {
                            //
                            // return list of metric names
                            //
                            return this.findMetrics(backend, { match: queryOptions.pattern }).then(function (result) {
                                return result.map(function (metric) {
                                    return metric.id;
                                });
                            });
                        } else {
                            return [];
                        }
                    }
                }, {
                    key: 'reset',
                    value: function reset() {
                        resetMetricsCache();
                    }
                }]);

                return MetricsService;
            }();

            _export('default', MetricsService);

            MetricsCache = function (_Cache) {
                _inherits(MetricsCache, _Cache);

                function MetricsCache() {
                    _classCallCheck(this, MetricsCache);

                    return _possibleConstructorReturn(this, (MetricsCache.__proto__ || Object.getPrototypeOf(MetricsCache)).call(this, 10, 60000));
                }

                _createClass(MetricsCache, [{
                    key: 'getItemId',
                    value: function getItemId(id) {
                        return Object.keys(id).map(function (k) {
                            return id[k];
                        }).join(',');
                    }
                }]);

                return MetricsCache;
            }(Cache);

            metricsCaches = void 0;
        }
    };
});
//# sourceMappingURL=metrics_service.js.map
