'use strict';

System.register([], function (_export, _context) {
    "use strict";

    var _createClass, FormatterService;

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    return {
        setters: [],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            FormatterService = function () {
                function FormatterService() {
                    _classCallCheck(this, FormatterService);
                }

                _createClass(FormatterService, null, [{
                    key: 'formatLabelValue',
                    value: function formatLabelValue(labelValue) {
                        return labelValue || FormatterService.NULL_TEXT;
                    }
                }, {
                    key: 'getSeriesName',
                    value: function getSeriesName(dataPoint, target, isTabularFormat, isSingleTarget, keys) {
                        var alias = void 0;
                        if (target.alias) {
                            alias = target.alias;
                        } else {
                            if (target.segmentBy.length === 0) {
                                // single entity
                                alias = '{{metric}}';
                            } else if (isTabularFormat === true) {
                                alias = '{{segment_name}}';
                            } else if (isSingleTarget === true) {
                                alias = '{{segment_value}}';
                            } else {
                                alias = '{{metric}} ({{segment_value}})';
                            }
                        }

                        var pattern = /\{\{((?:metric|segment_name|segment_value))(?::(\d*))?(?::(\d*))?(?:\s\/([^/]+)\/)?\}\}/g;

                        return alias.replace(pattern, function (match, token, startTrim, endTrim, regexpString) {
                            var startTrimIndex = Number.parseInt(startTrim);
                            var endTrimIndex = Number.parseInt(endTrim);

                            var output = void 0;
                            var trimmedGroup = token.trim();
                            if (trimmedGroup.startsWith('metric')) {
                                output = target.target;
                            }

                            if (trimmedGroup.startsWith('segment_name')) {
                                if (target.segmentBy.length > 0) {
                                    output = target.segmentBy.join(' - ');
                                } else {
                                    return '[all]';
                                }
                            }

                            if (trimmedGroup.startsWith('segment_value')) {
                                if (target.segmentBy.length > 0) {
                                    output = keys.map(function (segment) {
                                        return FormatterService.formatLabelValue(dataPoint[segment]);
                                    }).join(' - ');
                                } else {
                                    return '[all]';
                                }
                            }

                            if (startTrimIndex) {
                                if (endTrimIndex) {
                                    output = output.substring(0, startTrimIndex) + '..' + output.substring(output.length - endTrimIndex);
                                } else {
                                    output = output.substring(0, startTrimIndex) + '..';
                                }
                            } else if (endTrimIndex) {
                                output = '..' + output.substring(output.length - endTrimIndex);
                            }

                            if (regexpString) {
                                try {
                                    //
                                    // First, compile regular expression. Failures will invalidate the pattern entirely
                                    //
                                    var regexp = new RegExp(regexpString);

                                    //
                                    // Then, execute pattern against the current name
                                    //
                                    var matches = regexp.exec(output);

                                    if (matches && matches.length > 1) {
                                        //
                                        // And finally, joins all captured groups
                                        //
                                        output = matches.slice(1).join('');
                                    }
                                } catch (ex) {
                                    // noop
                                }
                            }

                            return output;
                        });
                    }
                }]);

                return FormatterService;
            }();

            _export('default', FormatterService);

            FormatterService.NULL_TEXT = 'n/a';
        }
    };
});
//# sourceMappingURL=formatter_service.js.map
