"use strict";

System.register([], function (_export, _context) {
    "use strict";

    var _createClass, Cache;

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    return {
        setters: [],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            Cache = function () {
                function Cache() {
                    var maxCount = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 10;
                    var expiration = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;

                    _classCallCheck(this, Cache);

                    this.map = {};
                    this.list = [];

                    this.maxCount = maxCount;
                    this.expiration = expiration;
                }

                _createClass(Cache, [{
                    key: "getItemId",
                    value: function getItemId(id) {
                        return id;
                    }
                }, {
                    key: "get",
                    value: async function get(id, loader) {
                        var data = this.read(id);
                        if (data !== undefined) {
                            return data;
                        } else {
                            var promise = this.fetch(loader);

                            // store promise as data first...
                            this.write(id, promise);

                            try {
                                // wait for data...
                                var _data = await promise;

                                // and finally store data in the cache
                                this.write(id, _data);

                                return _data;
                            } catch (ex) {
                                // delete pending item
                                var itemId = this.getItemId(id);
                                var item = this.map[itemId];
                                if (item !== undefined) {
                                    this.list = [].concat(_toConsumableArray(this.list.filter(function (d) {
                                        return d !== item;
                                    })));
                                    delete this.map[itemId];
                                }

                                throw ex;
                            }
                        }
                    }
                }, {
                    key: "read",
                    value: function read(id) {
                        var itemId = this.getItemId(id);

                        this.expireItems();
                        var item = this.map[itemId];

                        if (item) {
                            item.lastAccess = this.now();

                            // keep list sorted by creation time
                            this.list = [].concat(_toConsumableArray(this.list.filter(function (d) {
                                return d !== item;
                            })), [item]);

                            return item.data;
                        } else {
                            return undefined;
                        }
                    }
                }, {
                    key: "fetch",
                    value: function fetch(loader) {
                        return loader();
                    }
                }, {
                    key: "write",
                    value: function write(id, data) {
                        var itemId = this.getItemId(id);

                        var item = this.createItem(itemId, data);

                        // replace existing items (used to replace promise with data)
                        var previousItem = this.map[itemId];
                        if (previousItem !== undefined) {
                            this.list = [].concat(_toConsumableArray(this.list.filter(function (d) {
                                return d !== previousItem;
                            })));
                            delete this.map[itemId];
                        }

                        this.list.push(item);
                        this.map[itemId] = item;

                        this.evictItems();

                        return item.data;
                    }
                }, {
                    key: "createItem",
                    value: function createItem(itemId, data) {
                        var now = this.now();

                        return {
                            id: itemId,
                            data: data,
                            createdOn: now,
                            lastAccess: now
                        };
                    }
                }, {
                    key: "expireItems",
                    value: function expireItems() {
                        if (this.expiration !== Number.MAX_VALUE) {
                            var limit = this.now() - this.expiration;
                            var removed = [];
                            for (var i = this.list.length - 1; i >= 0; i--) {
                                var item = this.list[i];

                                if (item.createdOn < limit) {
                                    delete this.map[item.id];
                                    removed.push(i);
                                }
                            }

                            this.list = this.list.filter(function (d, i) {
                                return removed.indexOf(i) === -1;
                            });
                        }
                    }
                }, {
                    key: "evictItems",
                    value: function evictItems() {
                        if (this.list.length > this.maxCount) {
                            var removed = [];
                            for (var i = this.list.length - 1 - this.maxCount; i >= 0; i--) {
                                var item = this.list[i];

                                delete this.map[item.id];
                                removed.push(i);
                            }

                            this.list = this.list.filter(function (d, i) {
                                return removed.indexOf(i) === -1;
                            });
                        }
                    }
                }, {
                    key: "toArray",
                    value: function toArray() {
                        return this.list.map(function (item) {
                            return item.data;
                        });
                    }
                }, {
                    key: "now",
                    value: function now() {
                        return Date.now();
                    }
                }]);

                return Cache;
            }();

            _export("default", Cache);
        }
    };
});
//# sourceMappingURL=cache.js.map
