'use strict';

System.register(['./api_service', './sysdig_dashboard_helper'], function (_export, _context) {
    "use strict";

    var ApiService, SysdigDashboardHelper, _createClass, DashboardsService;

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    async function removeDashboards(backendSrv, dashboards) {
        if (dashboards.length > 0) {
            return removeNextDashboard(backendSrv, dashboards[0], dashboards.slice(1));
        } else {
            return;
        }
    }

    async function removeNextDashboard(backendSrv, dashboard, nextDashboards) {
        await backendSrv.deleteDashboard(dashboard.uid);

        try {
            await removeDashboards(backendSrv, nextDashboards);
        } catch (error) {
            console.error('Error deleting dashboard', dashboard.uid, error);
            await removeDashboards(backendSrv, nextDashboards);
        }
    }
    return {
        setters: [function (_api_service) {
            ApiService = _api_service.default;
        }, function (_sysdig_dashboard_helper) {
            SysdigDashboardHelper = _sysdig_dashboard_helper.default;
        }],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            DashboardsService = function () {
                function DashboardsService() {
                    _classCallCheck(this, DashboardsService);
                }

                _createClass(DashboardsService, null, [{
                    key: 'importFromSysdig',
                    value: async function importFromSysdig(backend, datasourceName, dashboardSetId) {
                        console.info('Sysdig dashboards import: Starting...');

                        if (dashboardSetId === 'DEFAULT') {
                            var tags = ['Sysdig', 'Default dashboard'];
                            var fetchResults = await Promise.all([ApiService.fetchDefaultDashboards(backend), ApiService.send(backend, {
                                url: 'data/drilldownViewsCategories.json'
                            })]);

                            var applicableDashboards = fetchResults[0].defaultDashboards;

                            var usedCategories = fetchResults[1].data.drilldownViewsCategories.filter(function (category) {
                                return applicableDashboards.find(function (dashboard) {
                                    return dashboard.category === category.id;
                                }) !== undefined;
                            });

                            var categories = usedCategories;
                            var defaultDashboards = applicableDashboards;
                            var version = fetchResults[0].version;

                            var convertedDashboards = defaultDashboards.map(convertDashboard.bind(null, datasourceName, version, categories, tags)).filter(function (dashboard) {
                                return dashboard !== null;
                            });

                            var options = {
                                overwrite: true
                            };

                            try {
                                var result = await saveDashboards(backend.backendSrv, convertedDashboards, options);

                                console.info('Sysdig dashboards import: Completed');

                                return result;
                            } catch (error) {
                                console.info('Sysdig dashboards import: Failed', error);

                                throw error;
                            }
                        } else {
                            var _tags = void 0;
                            switch (dashboardSetId) {
                                case 'PRIVATE':
                                    _tags = ['Sysdig', 'Private dashboard'];
                                    break;
                                case 'SHARED':
                                    _tags = ['Sysdig', 'Shared dashboard'];
                                    break;
                                default:
                                    throw {
                                        name: 'Invalid argument',
                                        message: 'Invalid dashboard set ID (\'' + dashboardSetId + '\')'
                                    };
                            }

                            var fetchResult = await ApiService.fetchDashboards(backend);

                            var _convertedDashboards = fetchResult.dashboards.filter(SysdigDashboardHelper.filterDashboardBySetId.bind(null, fetchResult.version, dashboardSetId)).map(convertDashboard.bind(null, datasourceName, fetchResult.version, [], _tags)).filter(function (dashboard) {
                                return dashboard !== null;
                            });

                            var _options = {
                                overwrite: true
                            };

                            try {
                                var saveResult = await saveDashboards(backend.backendSrv, _convertedDashboards, _options);

                                console.info('Sysdig dashboards import: Completed');

                                return saveResult;
                            } catch (error) {
                                console.info('Sysdig dashboards import: Failed', error);

                                throw error;
                            }
                        }

                        function convertDashboard(datasourceName, version, categories, tags, dashboard) {
                            try {
                                return SysdigDashboardHelper.convertToGrafana(version, dashboard, {
                                    datasourceName: datasourceName,
                                    categories: categories,
                                    tags: tags
                                });
                            } catch (error) {
                                console.error('An error occurred during the dashboard conversion', error, arguments);
                                return null;
                            }
                        }

                        async function saveDashboards(backendSrv, dashboards, options) {
                            if (dashboards.length > 0) {
                                var dashboard = dashboards[0];

                                await backendSrv.saveDashboard(dashboard, options);

                                console.log('Sysdig dashboards import: Imported \'' + dashboard.title + '\'');

                                return saveDashboards(backendSrv, dashboards.slice(1), options);
                            } else {
                                return {};
                            }
                        }
                    }
                }, {
                    key: 'delete',
                    value: async function _delete(backendSrv) {
                        return backendSrv.search({
                            type: 'dash-db',
                            tags: ['Sysdig', 'sysdig']
                        }).then(filterSysdigDashboards).then(function (dashboards) {
                            console.log('Sysdig dashboards: Delete ' + dashboards.length + ' dashboards...');

                            return removeDashboards(backendSrv, dashboards);
                        });

                        function filterSysdigDashboards(dashboards) {
                            // NOTE: Up to Grafana v6.1, search over 2 tags doesn't work, the list will include dashboards without tags as well
                            // Current workaround is to filter based on tags returned by each dashboard configuration
                            return dashboards.filter(function (dashboard) {
                                return dashboard.tags && (dashboard.tags.indexOf('sysdig') >= 0 || dashboard.tags.indexOf('Sysdig') >= 0);
                            });
                        }
                    }
                }]);

                return DashboardsService;
            }();

            _export('default', DashboardsService);
        }
    };
});
//# sourceMappingURL=dashboards_service.js.map
