'use strict';

System.register([], function (_export, _context) {
    "use strict";

    var _createClass, ApiService;

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function getGroupAggregations(metric, metricTypes) {
        if (metric.groupAggregations && metric.groupAggregations.length > 0) {
            return metric.groupAggregations;
        } else if (metricTypes.indexOf(metric.metricType) >= 0) {
            return ['avg', 'sum', 'min', 'max'];
        } else {
            return [];
        }
    }
    return {
        setters: [],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            ApiService = function () {
                function ApiService() {
                    _classCallCheck(this, ApiService);
                }

                _createClass(ApiService, null, [{
                    key: 'send',
                    value: function send(backend, options) {
                        var headers = {
                            'Content-Type': 'application/json',
                            'X-Sysdig-Product': 'SDC',
                            Authorization: 'Bearer ' + backend.apiToken
                        };

                        return backend.backendSrv.datasourceRequest(Object.assign({}, options, {
                            headers: headers,
                            url: backend.url + '/' + options.url,
                            method: options.method || 'GET'
                        }));
                    }
                }, {
                    key: 'fetchDefaultDashboards',
                    value: async function fetchDefaultDashboards(backend) {
                        try {
                            //
                            // Try latest version
                            //
                            var result = await this.send(backend, {
                                url: 'api/v2/defaultDashboards?excludeMissing=true'
                            });

                            if (result.data.defaultDashboards) {
                                return {
                                    defaultDashboards: result.data.defaultDashboards,
                                    version: 'v2'
                                };
                            } else {
                                //
                                // dev version of v2 detected, fallback to v1
                                // (api/v2/defaultDashboards returns an array and not and object with defaultDashboards array)
                                // NOTE: This is useful until onprem version X and SaaS version Y need to be supported
                                //
                                throw {
                                    status: 404
                                };
                            }
                        } catch (ex) {
                            //
                            // Check that latest version is not supported
                            //
                            if (ex.status === 404) {
                                //
                                // Try previous version
                                // (supported from v1245 released on 5/11/2018)
                                //
                                var _result = await this.send(backend, {
                                    url: 'api/defaultDashboards?excludeMissing=true'
                                });

                                return {
                                    defaultDashboards: _result.data.defaultDashboards,
                                    version: 'v1'
                                };
                            }
                        }
                    }
                }, {
                    key: 'fetchDashboards',
                    value: async function fetchDashboards(backend) {
                        try {
                            //
                            // Try latest version
                            //
                            var result = await ApiService.send(backend, {
                                url: 'api/v2/dashboards'
                            });

                            if (Array.isArray(result.data.dashboards) && result.data.dashboards.length > 0) {
                                return {
                                    dashboards: result.data.dashboards,
                                    version: 'v2'
                                };
                            } else {
                                //
                                // probable dev version of v2 detected, fallback to v1
                                // (api/v2/dashboards was not documented or used, it's supposed to be empty -- NOTE: could lead to false positive in case there are no dashboards to import)
                                // NOTE: This is useful until onprem version X and SaaS version Y need to be supported
                                //
                                throw {
                                    status: 404
                                };
                            }
                        } catch (ex) {
                            //
                            // Check that latest version is not supported
                            //
                            if (ex.status === 404) {
                                //
                                // Try previous version
                                // (supported from v1245 released on 5/11/2018)
                                //
                                var _result2 = await ApiService.send(backend, {
                                    url: 'ui/dashboards'
                                });

                                return {
                                    dashboards: _result2.data.dashboards,
                                    version: 'v1'
                                };
                            }
                        }
                    }
                }, {
                    key: 'fetchMetricsDescriptors',
                    value: async function fetchMetricsDescriptors(backend, options) {
                        var metricTypes = options.areLabelsIncluded ? [] : ['counter', 'gauge', 'histogram'];

                        try {
                            //
                            // Try latest version
                            //
                            var typesFilter = options.areLabelsIncluded ? [] : options.plottableMetricTypes;

                            var response = await ApiService.send(backend, {
                                url: 'api/v2/metrics/descriptors?offset=0&limit=100&filter=' + (options.match || '') + '&types=' + encodeURIComponent(typesFilter.join(',')) + '&metricTypes=' + encodeURIComponent(metricTypes.join(','))
                            });

                            return response.data.metricDescriptors;
                        } catch (ex) {
                            //
                            // Check that latest version is not supported
                            //
                            if (ex.status === 500) {
                                //
                                // Try previous version
                                //
                                var _response = await ApiService.send(backend, {
                                    url: 'api/data/metrics?light=true'
                                });

                                return Object.values(_response.data).map(function (d) {
                                    return Object.assign({}, d, {
                                        timeAggregations: d.aggregations,
                                        groupAggregations: getGroupAggregations(d, metricTypes)
                                    });
                                });
                            } else {
                                throw ex;
                            }
                        }
                    }
                }, {
                    key: 'fetchLabelDescriptors',
                    value: async function fetchLabelDescriptors(backend, options) {
                        try {
                            //
                            // Try latest version
                            //
                            var result = await this.send(backend, {
                                url: 'api/v2/labels/descriptors?offset=0&limit=100&filter=' + (options.match || '') + '&pids=' + (options.metric || '') + '&scope='
                            });

                            return result.data.labelDescriptors;
                        } catch (ex) {
                            //
                            // Check that latest version is not supported
                            //
                            if (ex.status === 404) {
                                //
                                // Try previous version
                                //
                                if (options.metric) {
                                    try {
                                        var _result3 = await this.send(backend, {
                                            url: 'api/data/metrics/' + options.metric + '/segmentationMetrics'
                                        });

                                        if (_result3.data.segmentationMetrics) {
                                            return _result3.data.segmentationMetrics.map(function (d) {
                                                return { id: d };
                                            });
                                        } else {
                                            return [];
                                        }
                                    } catch (ex) {
                                        //
                                        // Previous versions no longer supported
                                        //
                                    }
                                } else {
                                    return [];
                                }
                            } else {
                                throw ex;
                            }
                        }
                    }
                }]);

                return ApiService;
            }();

            _export('default', ApiService);
        }
    };
});
//# sourceMappingURL=api_service.js.map
