'use strict';

System.register(['app/plugins/sdk', './css/query-editor.css!', './datasource'], function (_export, _context) {
    "use strict";

    var QueryCtrl, DEFAULT_PAGE_LIMIT, _createClass, DEFAULT_TIME_AGGREGATIONS, DEFAULT_TIME_AGGREGATIONS_MAP, DEFAULT_GROUP_AGGREGATIONS, DEFAULT_GROUP_AGGREGATIONS_MAP, SysdigDatasourceQueryCtrl;

    function _toConsumableArray(arr) {
        if (Array.isArray(arr)) {
            for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
                arr2[i] = arr[i];
            }

            return arr2;
        } else {
            return Array.from(arr);
        }
    }

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function _possibleConstructorReturn(self, call) {
        if (!self) {
            throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
        }

        return call && (typeof call === "object" || typeof call === "function") ? call : self;
    }

    function _inherits(subClass, superClass) {
        if (typeof superClass !== "function" && superClass !== null) {
            throw new TypeError("Super expression must either be null or a function, not " + typeof superClass);
        }

        subClass.prototype = Object.create(superClass && superClass.prototype, {
            constructor: {
                value: subClass,
                enumerable: false,
                writable: true,
                configurable: true
            }
        });
        if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass;
    }

    function getAggregationList(aggregations, knownList, knownMap) {
        return aggregations.map(function (d) {
            var descr = knownMap[d];

            return descr || { text: d, value: d };
        }).sort(function (a, b) {
            var indexA = knownList.indexOf(a);
            var indexB = knownList.indexOf(b);

            if (indexA !== indexB) {
                return indexA - indexB;
            } else {
                return a.text.localeCompare(b.text);
            }
        });
    }
    return {
        setters: [function (_appPluginsSdk) {
            QueryCtrl = _appPluginsSdk.QueryCtrl;
        }, function (_cssQueryEditorCss) {}, function (_datasource) {
            DEFAULT_PAGE_LIMIT = _datasource.DEFAULT_PAGE_LIMIT;
        }],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            DEFAULT_TIME_AGGREGATIONS = [{ value: 'timeAvg', text: 'Time average' }, { value: 'rateOfChange', text: 'Rate of change' }, { value: 'avg', text: 'Average' }, { value: 'sum', text: 'Sum' }, { value: 'min', text: 'Min' }, { value: 'max', text: 'Max' }, { value: 'count', text: 'Count' }, { value: 'concat', text: 'Concat' }, { value: 'distinct', text: 'Distinct' }];
            DEFAULT_TIME_AGGREGATIONS_MAP = DEFAULT_TIME_AGGREGATIONS.reduce(function (acc, d) {
                acc[d.value] = d;
                return acc;
            }, {});
            DEFAULT_GROUP_AGGREGATIONS = [{ value: 'avg', text: 'Average' }, { value: 'sum', text: 'Sum' }, { value: 'min', text: 'Min' }, { value: 'max', text: 'Max' }, { value: 'count', text: 'Count' }, { value: 'concat', text: 'Concat' }, { value: 'distinct', text: 'Distinct' }];
            DEFAULT_GROUP_AGGREGATIONS_MAP = DEFAULT_GROUP_AGGREGATIONS.reduce(function (acc, d) {
                acc[d.value] = d;
                return acc;
            }, {});

            _export('SysdigDatasourceQueryCtrl', SysdigDatasourceQueryCtrl = function (_QueryCtrl) {
                _inherits(SysdigDatasourceQueryCtrl, _QueryCtrl);

                function SysdigDatasourceQueryCtrl($scope, $injector) {
                    _classCallCheck(this, SysdigDatasourceQueryCtrl);

                    var _this = _possibleConstructorReturn(this, (SysdigDatasourceQueryCtrl.__proto__ || Object.getPrototypeOf(SysdigDatasourceQueryCtrl)).call(this, $scope, $injector));

                    _this.scope = $scope;
                    _this.target.target = _this.target.target || 'cpu.used.percent';
                    _this.target.timeAggregation = _this.target.timeAggregation || 'timeAvg';
                    _this.target.groupAggregation = _this.target.groupAggregation || 'avg';

                    if (_this.target.segmentBy) {
                        if (Array.isArray(_this.target.segmentBy) === false) {
                            _this.target.segmentBy = [_this.target.segmentBy];
                        }
                    } else {
                        _this.target.segmentBy = [];
                    }

                    _this.target.sortDirection = _this.target.sortDirection || 'desc';
                    _this.target.isSingleDataPoint = _this.target.isTabularFormat;

                    _this.segmentByItems = _this.calculateSegmentByItems();
                    return _this;
                }

                _createClass(SysdigDatasourceQueryCtrl, [{
                    key: 'isFirstTarget',
                    value: function isFirstTarget() {
                        return this.panel.targets.indexOf(this.target) === 0;
                    }
                }, {
                    key: 'isTabularFormat',
                    value: function isTabularFormat() {
                        return this.panel.targets[0].isTabularFormat;
                    }
                }, {
                    key: 'getLimitPlaceholder',
                    value: function getLimitPlaceholder() {
                        return DEFAULT_PAGE_LIMIT + ' (element count)';
                    }
                }, {
                    key: 'getVariableItems',
                    value: function getVariableItems() {
                        return this.datasource.templateSrv.variables.map(function (variable) {
                            var text = '${' + variable.name + '}';
                            return { text: text, value: text };
                        });
                    }
                }, {
                    key: 'getMetricOptions',
                    value: function getMetricOptions(query) {
                        var _this2 = this;

                        var parseMetric = void 0;
                        var options = {
                            areLabelsIncluded: this.isTabularFormat(),
                            match: query
                        };

                        if (!this.isTabularFormat()) {
                            parseMetric = function parseMetric(m) {
                                return { text: m.id, value: m.id };
                            };
                        } else {
                            parseMetric = function parseMetric(m) {
                                if (m.isNumeric) {
                                    return { text: '(#) ' + m.id, value: m.id };
                                } else {
                                    return { text: '(A) ' + m.id, value: m.id };
                                }
                            };
                        }

                        return this.datasource.metricFindQuery(null, options).then(function (data) {
                            return [].concat(_toConsumableArray(_this2.getVariableItems()), _toConsumableArray(data.map(parseMetric)));
                        });
                    }
                }, {
                    key: 'getAggregationOptions',
                    value: function getAggregationOptions() {
                        return this.datasource.metricFindQuery(null, { match: this.target.target }).then(function (data) {
                            return data.length > 0 ? data[0] : null;
                        });
                    }
                }, {
                    key: 'getTimeAggregationOptions',
                    value: function getTimeAggregationOptions() {
                        return this.getAggregationOptions().then(function (m) {
                            if (m) {
                                return getAggregationList(m.timeAggregations, DEFAULT_TIME_AGGREGATIONS, DEFAULT_TIME_AGGREGATIONS_MAP);
                            } else {
                                return [];
                            }
                        });
                    }
                }, {
                    key: 'getGroupAggregationOptions',
                    value: function getGroupAggregationOptions() {
                        return this.getAggregationOptions().then(function (m) {
                            if (m) {
                                return getAggregationList(m.groupAggregations, DEFAULT_GROUP_AGGREGATIONS, DEFAULT_GROUP_AGGREGATIONS_MAP);
                            } else {
                                return [];
                            }
                        });
                    }
                }, {
                    key: 'getSortDirectionOptions',
                    value: function getSortDirectionOptions() {
                        return [{ value: 'desc', text: 'Top' }, { value: 'asc', text: 'Bottom' }];
                    }
                }, {
                    key: 'getSegmentByOptions',
                    value: function getSegmentByOptions(item, query) {
                        var _this3 = this;

                        return this.datasource.findSegmentBy(this.target.target, query !== 'select metric' && query !== '' ? query : null).then(function (data) {
                            return [{ text: 'no segmentation', value: null }].concat(_toConsumableArray(_this3.getVariableItems()), _toConsumableArray(data.map(function (m) {
                                return { text: m.id, value: m.id };
                            })));
                        });
                    }
                }, {
                    key: 'removeSegmentBy',
                    value: function removeSegmentBy(item) {
                        var index = this.segmentByItems.indexOf(item);

                        // remove segmentation from list
                        this.target.segmentBy = [].concat(_toConsumableArray(this.target.segmentBy.slice(0, index)), _toConsumableArray(this.target.segmentBy.slice(index + 1)));

                        // update UI list
                        this.segmentByItems = this.calculateSegmentByItems();

                        // update data
                        this.panelCtrl.refresh();
                    }
                }, {
                    key: 'addSegmentBy',
                    value: function addSegmentBy(item) {
                        var index = this.segmentByItems.indexOf(item);

                        // add new item after the one where + has been clicked
                        this.segmentByItems = [].concat(_toConsumableArray(this.segmentByItems.slice(0, index + 1)), [{
                            isFirst: false,
                            canAdd: true,
                            segmentBy: null
                        }], _toConsumableArray(this.segmentByItems.slice(index + 1)));

                        // don't update the UI: the change is temporary until the user picks a segmentation
                    }
                }, {
                    key: 'onChangeParameter',
                    value: function onChangeParameter() {
                        this.panelCtrl.refresh();

                        this.target.segmentBy = this.segmentByItems.filter(function (item) {
                            return item.segmentBy !== null;
                        }).map(function (item) {
                            return item.segmentBy;
                        });

                        this.segmentByItems = this.calculateSegmentByItems();
                    }
                }, {
                    key: 'calculateSegmentByItems',
                    value: function calculateSegmentByItems() {
                        var _this4 = this;

                        if (this.target.segmentBy.length === 0) {
                            return [{
                                isFirst: true,
                                canAdd: false,
                                segmentBy: null
                            }];
                        } else {
                            return this.target.segmentBy.map(function (segmentBy, i) {
                                return {
                                    isFirst: i === 0,
                                    canAdd: i === _this4.target.segmentBy.length - 1,
                                    segmentBy: segmentBy
                                };
                            });
                        }
                    }
                }, {
                    key: 'toggleEditorMode',
                    value: function toggleEditorMode() {
                        // noop
                    }
                }, {
                    key: 'onChangeTabularFormat',
                    value: function onChangeTabularFormat() {
                        this.target.isSingleDataPoint = this.target.isTabularFormat;
                        this.refresh();
                    }
                }]);

                return SysdigDatasourceQueryCtrl;
            }(QueryCtrl));

            _export('SysdigDatasourceQueryCtrl', SysdigDatasourceQueryCtrl);

            SysdigDatasourceQueryCtrl.templateUrl = 'partials/query.editor.html';
        }
    };
});
//# sourceMappingURL=query_ctrl.js.map
