'use strict';

System.register(['lodash', './data_service', './api_service', './metrics_service', './templating_service', './formatter_service'], function (_export, _context) {
    "use strict";

    var _, DataService, ApiService, MetricsService, TemplatingService, FormatterService, _createClass, DEFAULT_PAGE_LIMIT, SORT_OPTIONS, SysdigDatasource;

    function _classCallCheck(instance, Constructor) {
        if (!(instance instanceof Constructor)) {
            throw new TypeError("Cannot call a class as a function");
        }
    }

    function convertRangeToUserTime(range, intervalMs) {
        if (range) {
            var userTime = {
                from: Math.trunc(range.from.valueOf() / 1000),
                to: Math.trunc(range.to.valueOf() / 1000)
            };

            if (intervalMs) {
                userTime.sampling = Math.max(Math.trunc(intervalMs / 1000), 1);
            }

            return userTime;
        } else {
            return null;
        }
    }
    return {
        setters: [function (_lodash) {
            _ = _lodash.default;
        }, function (_data_service) {
            DataService = _data_service.default;
        }, function (_api_service) {
            ApiService = _api_service.default;
        }, function (_metrics_service) {
            MetricsService = _metrics_service.default;
        }, function (_templating_service) {
            TemplatingService = _templating_service.default;
        }, function (_formatter_service) {
            FormatterService = _formatter_service.default;
        }],
        execute: function () {
            _createClass = function () {
                function defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) descriptor.writable = true;
                        Object.defineProperty(target, descriptor.key, descriptor);
                    }
                }

                return function (Constructor, protoProps, staticProps) {
                    if (protoProps) defineProperties(Constructor.prototype, protoProps);
                    if (staticProps) defineProperties(Constructor, staticProps);
                    return Constructor;
                };
            }();

            _export('DEFAULT_PAGE_LIMIT', DEFAULT_PAGE_LIMIT = 20);

            _export('DEFAULT_PAGE_LIMIT', DEFAULT_PAGE_LIMIT);

            SORT_OPTIONS = {
                asc: 'asc',
                bottom: 'asc',
                desc: 'desc',
                top: 'desc'
            };

            _export('SysdigDatasource', SysdigDatasource = function () {
                function SysdigDatasource(instanceSettings, backendSrv, templateSrv) {
                    _classCallCheck(this, SysdigDatasource);

                    this.name = instanceSettings.name;
                    this.backendSrv = backendSrv;
                    this.templateSrv = templateSrv;
                    this.url = instanceSettings.url;
                    this.access = 'proxy';

                    this.apiToken = instanceSettings.jsonData ? instanceSettings.jsonData.apiToken : '';
                    this.headers = {
                        'Content-Type': 'application/json',
                        'X-Sysdig-Product': 'SDC',
                        Authorization: 'Bearer ' + this.apiToken
                    };
                }

                _createClass(SysdigDatasource, [{
                    key: 'getBackendConfiguration',
                    value: function getBackendConfiguration() {
                        return {
                            backendSrv: this.backendSrv,
                            withCredentials: this.withCredentials,
                            headers: this.headers,
                            apiToken: this.apiToken,
                            url: this.url
                        };
                    }
                }, {
                    key: 'testDatasource',
                    value: async function testDatasource() {
                        var response = await ApiService.send(this.getBackendConfiguration(), {
                            url: 'api/login'
                        });

                        if (response.status === 200) {
                            return {
                                status: 'success',
                                message: 'Data source is working',
                                title: 'Success'
                            };
                        }
                    }
                }, {
                    key: 'query',
                    value: async function query(options) {
                        var query = this.buildQueryParameters(options);
                        query.targets = query.targets.filter(function (t) {
                            return !t.hide;
                        });

                        if (query.targets.length <= 0) {
                            return { data: [] };
                        }

                        return DataService.fetch(this.getBackendConfiguration(), query, convertRangeToUserTime(options.range, query.intervalMs));
                    }
                }, {
                    key: 'buildQueryParameters',
                    value: function buildQueryParameters(options) {
                        var _this = this;

                        //remove placeholder targets
                        options.targets = _.filter(options.targets, function (target) {
                            return target.target !== 'select metric';
                        });

                        var targets = _.map(options.targets, function (target, i, targets) {
                            if (target.target === undefined) {
                                // here's the query control panel sending the first request with empty configuration
                                return Object.assign({}, target, {
                                    target: 'cpu.used.percent',
                                    timeAggregation: 'timeAvg',
                                    groupAggregation: 'avg',
                                    filter: undefined,
                                    pageLimit: DEFAULT_PAGE_LIMIT,
                                    segmentBy: []
                                });
                            } else {
                                var isTabularFormat = targets[0].isTabularFormat;
                                var targetOptions = {
                                    segmentBy: isTabularFormat === false ? target.segmentBy : targets[0].segmentBy,
                                    filter: isTabularFormat === false ? target.filter : targets[0].filter,

                                    // pagination configuration is set for first target only
                                    pageLimit: targets[0].pageLimit,
                                    sortDirection: targets[0].sortDirection,

                                    // "single data point" configuration is set for first target only
                                    isSingleDataPoint: isTabularFormat || targets[0].isSingleDataPoint
                                };

                                if (targetOptions.segmentBy && Array.isArray(targetOptions.segmentBy) === false) {
                                    // backwards compatibility: up to v0.3 one segmentation was supported only
                                    targetOptions.segmentBy = [targetOptions.segmentBy];
                                }

                                return Object.assign({}, target, targetOptions, {
                                    segmentBy: targetOptions.segmentBy ? targetOptions.segmentBy.map(function (segmentBy) {
                                        return _this.resolveTemplate(segmentBy, true, options);
                                    }) : [],
                                    filter: _this.resolveTemplate(targetOptions.filter, true, options),

                                    pageLimit: _this.resolveTemplate(targetOptions.pageLimit, true, options, function (d) {
                                        return Number.parseInt(d) || DEFAULT_PAGE_LIMIT;
                                    }),
                                    sortDirection: _this.resolveTemplate(targetOptions.sortDirection, true, options, function (d) {
                                        return SORT_OPTIONS[(d || 'top').toLowerCase()] || SORT_OPTIONS['top'];
                                    }),

                                    target: _this.resolveTemplate(target.target, true, options),
                                    timeAggregation: _this.resolveTemplate(target.timeAggregation, true, options),
                                    groupAggregation: _this.resolveTemplate(target.groupAggregation, true, options),

                                    alias: _this.resolveTemplate(target.alias, true, options)
                                });
                            }
                        });

                        options.targets = targets;

                        return options;
                    }
                }, {
                    key: 'resolveTemplate',
                    value: function resolveTemplate(input, isSingleMatch, options, parser) {
                        var normParser = parser || function (d) {
                            return d;
                        };

                        if (typeof input === 'string') {
                            return normParser(TemplatingService.replace(this.templateSrv, input, (options || {}).scopedVars));
                        } else {
                            return normParser(input);
                        }
                    }
                }, {
                    key: 'metricFindQuery',
                    value: async function metricFindQuery(query, options) {
                        var normOptions = Object.assign({ areLabelsIncluded: false, range: null, variable: null, match: '' }, options);

                        if (query) {
                            //
                            // variable query
                            //
                            var result = await MetricsService.queryMetrics(this.getBackendConfiguration(), this.templateSrv, query, { userTime: convertRangeToUserTime(normOptions.range) });

                            return result.sort(this.getLabelValuesSorter(normOptions.variable.sort)).map(function (labelValue) {
                                return {
                                    text: FormatterService.formatLabelValue(labelValue)
                                };
                            });
                        } else {
                            //
                            // panel configuration query
                            //
                            var _result = await MetricsService.findMetrics(this.getBackendConfiguration(), {
                                areLabelsIncluded: normOptions.areLabelsIncluded,
                                match: normOptions.match
                            });

                            // filter out all tags/labels/other string metrics

                            if (normOptions.areLabelsIncluded) {
                                return _result;
                            } else {
                                return _result.filter(function (metric) {
                                    return metric.isNumeric;
                                });
                            }
                        }
                    }
                }, {
                    key: 'findSegmentBy',
                    value: async function findSegmentBy(metric, query) {
                        if (metric) {
                            return MetricsService.findSegmentations(this.getBackendConfiguration(), {
                                metric: metric,
                                match: this.resolveTemplate(query, true)
                            });
                        } else {
                            return [];
                        }
                    }
                }, {
                    key: 'getLabelValuesSorter',
                    value: function getLabelValuesSorter(mode) {
                        switch (mode) {
                            case 0: // disabled
                            case 1:
                                // alphabetical (asc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a.localeCompare(b);
                                };

                            case 3:
                                // numerical (asc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a - b;
                                };

                            case 2:
                                // alphabetical (desc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a.localeCompare(b);
                                };

                            case 4:
                                // numerical (desc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a - b;
                                };

                            case 5:
                                // alphabetical, case insensitive (asc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a.localeCompare(b);
                                };

                            case 6:
                                // alphabetical, case insensitive (desc)
                                return function (a, b) {
                                    if (a === null) return -1;else if (b === null) return 1;else return a.toLowerCase().localeCompare(b.toLowerCase());
                                };
                        }
                    }
                }, {
                    key: 'annotationQuery',
                    value: async function annotationQuery() {
                        // const query = this.templateSrv.replace(options.annotation.query, {}, 'glob');
                        // const annotationQuery = {
                        //     range: options.range,
                        //     annotation: {
                        //         name: options.annotation.name,
                        //         datasource: options.annotation.datasource,
                        //         enable: options.annotation.enable,
                        //         iconColor: options.annotation.iconColor,
                        //         query: query
                        //     },
                        //     rangeRaw: options.rangeRaw
                        // };

                        // TODO Not supported yet
                        return [];
                    }
                }]);

                return SysdigDatasource;
            }());

            _export('SysdigDatasource', SysdigDatasource);
        }
    };
});
//# sourceMappingURL=datasource.js.map
